/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.access.api.AcaUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HscCimomListener;
import com.ibm.hsc.common.util.UserInfo;
import com.ibm.hsc.indication.client.HSCCltEventQueue;
import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hsc.indication.client.HSCSubscriptionMgr;
import com.ibm.hsc.indication.client.HSCSubscriptionMgrFactory;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.websm.bridge.WRemoteSystem;
import com.ibm.websm.bridge.WServer;
import com.ibm.websm.bridge.WSession;
import com.ibm.websm.console.WConsole;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EAuthorization;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMNameSpace;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMClient;

public class HscUtilBase {
    public static final int HU_WEBSM_INIT = 1;
    public static final int HU_WEBSM = 2;
    public static final int HU_SINGLECMD = 3;
    public static final int HU_CMDCTRL = 4;
    public static final int HU_CCFW = 5;
    protected static int s_utilOwner = 0;
    private static String s_uname = "unknownuser";
    private static String s_magickey = "NO_KEY_SET";
    public static final String KEY_SEPARATOR = "~";
    private static final CIMDataType _strArrayType;
    private static HSCSubscriptionMgr subscription;
    private static HscCimomListener _cimomListener;
    private static boolean _debug;

    public static int initHscUtil(int n) {
        if (n >= 1 && n <= 5 && s_utilOwner == 0 || s_utilOwner == 1) {
            s_utilOwner = n;
            switch (s_utilOwner) {
                case 3: {
                    s_uname = System.getProperty("HMCRealUser.name");
                    if (s_uname == null) {
                        s_uname = AcaUtils.getUsername();
                    }
                    if ((s_magickey = AcaUtils.getPwdkeyByName((String)s_uname)) != null) break;
                    s_magickey = "NO_KEY_SET";
                }
            }
        }
        return s_utilOwner;
    }

    public static Vector decodeKey(String string) {
        Vector<String> vector = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEY_SEPARATOR, false);
        if (stringTokenizer != null) {
            vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CIMValue getCIMAttribute(String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                CIMValue cIMValue;
                CIMValue cIMValue2 = cIMClient.getProperty(cIMObjectPath, string2);
                String string3 = cIMObjectPath.getObjectName();
                if (string2.equalsIgnoreCase("classCodeInfo") && string3.equalsIgnoreCase("IBMHSC_PCISlot")) {
                    cIMValue = cIMClient.getProperty(cIMObjectPath, "classCode");
                    cIMValue2 = HscUtilBase.handleSlotClassCode(cIMValue, cIMValue2);
                }
                cIMValue = cIMValue2;
                return cIMValue;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCIMAttribute(String string, CIMObjectPath cIMObjectPath, String string2, CIMValue cIMValue) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                cIMClient.setProperty(cIMObjectPath, string2, cIMValue);
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getCIMAssociation(String string, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                Enumeration enumeration;
                Enumeration enumeration2 = enumeration = cIMClient.associatorNames(cIMObjectPath, string2, string3, string4, string5);
                return enumeration2;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getCIMAssociationInst(String string, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                Enumeration enumeration = cIMClient.associators(cIMObjectPath, string2, string3, string4, string5, bl, bl2, stringArray);
                Enumeration enumeration2 = HscUtilBase.handleClassCode(string3, enumeration);
                return enumeration2;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getCIMReferences(String string, CIMObjectPath cIMObjectPath, String string2, String string3) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                Enumeration enumeration;
                Enumeration enumeration2 = enumeration = cIMClient.referenceNames(cIMObjectPath, string2, string3);
                return enumeration2;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getCIMReferencesInst(String string, CIMObjectPath cIMObjectPath, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                Enumeration enumeration;
                Enumeration enumeration2 = enumeration = cIMClient.references(cIMObjectPath, string2, string3, bl, bl2, stringArray);
                return enumeration2;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getCIMEnumInstances(String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                Enumeration enumeration;
                Enumeration enumeration2 = enumeration = cIMClient.enumInstances(cIMObjectPath, bl);
                return enumeration2;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getCIMEnumInstances(String string, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        Enumeration enumeration = null;
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                enumeration = bl ? cIMClient.enumInstances(cIMObjectPath, false, bl2) : cIMClient.enumInstances(cIMObjectPath, true, bl2);
                Enumeration enumeration2 = enumeration;
                return enumeration2;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    private static Enumeration handleClassCode(String string, Enumeration enumeration) {
        if (!string.equals("IBMHSC_PCISlot")) {
            return enumeration;
        }
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            HscUtilBase.handleSlotClassCode(cIMInstance);
            vector.addElement(cIMInstance);
        }
        return vector.elements();
    }

    private static void handleSlotClassCode(CIMInstance cIMInstance) {
        CIMProperty cIMProperty = cIMInstance.getProperty("ClassCodeInfo");
        CIMValue cIMValue = cIMProperty.getValue();
        CIMValue cIMValue2 = cIMInstance.getProperty("ClassCode").getValue();
        cIMProperty.setValue(HscUtilBase.handleSlotClassCode(cIMValue2, cIMValue));
    }

    private static CIMValue handleSlotClassCode(CIMValue cIMValue, CIMValue cIMValue2) {
        String string = null;
        String string2 = null;
        CIMValue cIMValue3 = null;
        cIMValue3 = cIMValue == null || cIMValue2 == null || (string = (String)cIMValue2.getValue()) == null || (string2 = (String)cIMValue.getValue()) == null || string.equals("Empty") ? new CIMValue((Object)HSCResourceBundleUtil.getMessage("ProfileBundle", "EMPTY_SLOT", "Empty")) : new CIMValue((Object)HSCResourceBundleUtil.getMessage("HscPciClassCodeInfo", string2, string));
        return cIMValue3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CIMInstance getCIMInstance(String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                CIMInstance cIMInstance = cIMClient.getInstance(cIMObjectPath, bl);
                String string2 = cIMObjectPath.getObjectName();
                CIMInstance cIMInstance2 = cIMInstance;
                return cIMInstance2;
            }
            catch (Throwable throwable) {
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CIMClass getCIMClass(String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                CIMClass cIMClass;
                CIMClass cIMClass2 = cIMClass = cIMClient.getClass(cIMObjectPath, bl);
                return cIMClass2;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static CIMInstance createNewCIMInstance(CIMClass cIMClass) throws CIMException {
        return cIMClass.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CIMObjectPath createCIMInstance(String string, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                CIMObjectPath cIMObjectPath2;
                CIMObjectPath cIMObjectPath3 = cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
                return cIMObjectPath3;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCIMInstance(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                cIMClient.deleteInstance(cIMObjectPath);
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCIMInstance(String string, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                cIMClient.setInstance(cIMObjectPath, cIMInstance);
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CIMValue invokeCIMMethod(String string, CIMObjectPath cIMObjectPath, String string2, Vector vector, Vector vector2) throws CIMException {
        CIMClient cIMClient = HscUtilBase._getCIMClient("localhost", cIMObjectPath.getNameSpace());
        if (cIMClient != null) {
            try {
                CIMValue cIMValue = cIMClient.invokeMethod(cIMObjectPath, string2, vector, vector2);
                cIMValue = HscUtilBase.nlsChkVal(cIMValue);
                if (vector2 != null && vector2.size() > 0) {
                    HscUtilBase.nlsChkVec(vector2);
                }
                CIMValue cIMValue2 = cIMValue;
                return cIMValue2;
            }
            finally {
                HscUtilBase._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    private static CIMValue nlsChkVal(CIMValue cIMValue) {
        if (cIMValue == null || cIMValue.isEmpty() || cIMValue.isNullValue()) {
            return cIMValue;
        }
        Object object = cIMValue.getValue();
        if (object == null) {
            return cIMValue;
        }
        if (!cIMValue.isArrayValue() && !(object instanceof String)) {
            return cIMValue;
        }
        if (object instanceof String) {
            return new CIMValue((Object)HSCResourceBundleUtil.decodeNLSMsgs((String)object));
        }
        if (!cIMValue.getType().equals((Object)_strArrayType)) {
            return cIMValue;
        }
        Vector vector = (Vector)object;
        if (vector.size() < 1) {
            return cIMValue;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            vector.set(i, HSCResourceBundleUtil.decodeNLSMsgs(string));
        }
        return cIMValue;
    }

    private static void nlsChkVec(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CIMValue cIMValue;
            Object e = vector.elementAt(i);
            if (e == null) continue;
            if (e instanceof CIMValue) {
                cIMValue = HscUtilBase.nlsChkVal((CIMValue)e);
                if (cIMValue == e) continue;
                vector.set(i, cIMValue);
                continue;
            }
            cIMValue = HscUtilBase.nlsChkVal(((CIMProperty)e).getValue());
            ((CIMProperty)e).setValue(cIMValue);
        }
    }

    public static String getOriginalUser() {
        String string = null;
        try {
            switch (s_utilOwner) {
                case 1: {
                    EAuthorization eAuthorization = null;
                    if (WConsole.getConsole() != null) {
                        WSession wSession = WConsole.getConsole().getSession();
                        WRemoteSystem wRemoteSystem = wSession.getRemoteSystem();
                        eAuthorization = wRemoteSystem.getAuthorization();
                    } else {
                        eAuthorization = WServer.getAuthorization();
                    }
                    string = eAuthorization.getName();
                    if (string == null) {
                        string = "wsmunknownuser";
                        break;
                    }
                    s_uname = string;
                    s_magickey = AcaUtils.getPwdkeyByName((String)string);
                    s_utilOwner = 2;
                    break;
                }
                case 2: 
                case 3: {
                    string = s_uname;
                    break;
                }
                case 4: {
                    UserInfo userInfo = UserInfo.getUser();
                    if (userInfo == null) {
                        string = "cmdunknownuser";
                        break;
                    }
                    string = userInfo.getUserName();
                    break;
                }
                case 5: {
                    UserContext userContext = UserContext.getCurrentUserContext();
                    if (userContext != null && userContext.isUser()) {
                        string = userContext.getUserid();
                    }
                    if (string == null) {
                        string = "root";
                    }
                    break;
                }
                default: {
                    string = "unknownuser";
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            if (_debug) {
                System.err.println("Exception in getOriginalUser(): " + throwable);
                throwable.printStackTrace();
            }
            string = "unknownuser";
        }
        return string;
    }

    public static CIMClient openCIMClient(String string, String string2) {
        return HscUtilBase._getCIMClient("localhost", string2);
    }

    private static CIMClient _getCIMClient(String string, String string2) {
        CIMClient cIMClient = null;
        try {
            CIMNameSpace cIMNameSpace = new CIMNameSpace("localhost", string2);
            switch (s_utilOwner) {
                case 1: {
                    s_uname = HscUtilBase.getOriginalUser();
                    cIMClient = new CIMClient(cIMNameSpace, s_uname, s_magickey);
                    break;
                }
                case 2: 
                case 3: {
                    cIMClient = new CIMClient(cIMNameSpace, s_uname, s_magickey);
                    break;
                }
                case 4: {
                    UserInfo userInfo = UserInfo.getUser();
                    if (userInfo == null) {
                        return null;
                    }
                    cIMClient = new CIMClient(cIMNameSpace, userInfo.getUserName(), userInfo.getLoginKey());
                    break;
                }
                case 5: {
                    String string3 = HscUtilBase.getOriginalUser();
                    cIMClient = new CIMClient(cIMNameSpace, string3, AcaUtils.getPwdkeyByName((String)string3));
                    break;
                }
                default: {
                    String string4 = AcaUtils.getUsername();
                    cIMClient = new CIMClient(cIMNameSpace, string4, AcaUtils.getPwdkeyByName((String)string4));
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            if (_debug) {
                System.err.println("CIM Exception in _getCIMClient: " + throwable);
                throwable.printStackTrace();
            }
            return null;
        }
        return cIMClient;
    }

    private static void _closeCIMClient(CIMClient cIMClient) {
        block3: {
            if (cIMClient != null) {
                try {
                    cIMClient.close();
                }
                catch (Exception exception) {
                    if (!_debug) break block3;
                    exception.printStackTrace();
                }
            }
        }
    }

    public static CIMObjectPath constructPath(CIMInstance cIMInstance, String string) {
        Vector vector = cIMInstance.getKeyValuePairs();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName(), string);
        cIMObjectPath.setKeys(vector);
        return cIMObjectPath;
    }

    public static void subscribeForCIMEvent(String string, String string2) {
        if (_cimomListener == null) {
            HscUtilBase._setEventNotification("localhost", string2);
        }
    }

    private static void _setEventNotification(String string, String string2) {
        block18: {
            String string3;
            String string4;
            HSCCltEventQueue hSCCltEventQueue;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            int n;
                            int n2;
                            HSCEvent.DebugEnabled = IDebug.enabled;
                            hSCCltEventQueue = null;
                            string4 = HscUtilBase.getOriginalUser();
                            string3 = s_magickey;
                            try {
                                if (_debug) {
                                    System.err.println("In _setEventNotification");
                                }
                                _cimomListener = new HscCimomListener();
                                hSCCltEventQueue = new HSCCltEventQueue(_cimomListener);
                                subscription = HSCSubscriptionMgrFactory.createSubscriptionMgr("localhost", null, -1, true, -1, null, _cimomListener);
                                _cimomListener.setSubscriptionMgr(subscription);
                                _cimomListener.setEventQueue(hSCCltEventQueue);
                                _cimomListener.start();
                            }
                            catch (Throwable throwable) {
                                _cimomListener = null;
                                subscription = null;
                                if (_debug) {
                                    throwable.printStackTrace();
                                }
                                return;
                            }
                            int n3 = n2 = 447;
                            int n4 = n = 7;
                            int n5 = n;
                            try {
                                subscription.subscribe(304, "IBMHSC_ComputerSystem", string4, string3, hSCCltEventQueue);
                                subscription.subscribe(1, "IBMHSC_ComputerSystem", string4, string3, hSCCltEventQueue);
                                subscription.subscribe(2, "IBMHSC_ComputerSystem", string4, string3, hSCCltEventQueue);
                                subscription.subscribe(4, "IBMHSC_ComputerSystem", string4, string3, hSCCltEventQueue);
                                subscription.subscribe(8, "IBMHSC_ComputerSystem", string4, string3, hSCCltEventQueue);
                                subscription.subscribe(16, "IBMHSC_ComputerSystem", string4, string3, hSCCltEventQueue);
                                subscription.subscribe(32, "IBMHSC_ComputerSystem", string4, string3, hSCCltEventQueue);
                                subscription.subscribe(128, "IBMHSC_ComputerSystem", string4, string3, hSCCltEventQueue);
                            }
                            catch (Throwable throwable) {
                                if (!_debug) break block14;
                                throwable.printStackTrace();
                            }
                        }
                        try {
                            subscription.subscribe(304, "IBMHSC_Partition", string4, string3, hSCCltEventQueue);
                            subscription.subscribe(1, "IBMHSC_Partition", string4, string3, hSCCltEventQueue);
                            subscription.subscribe(2, "IBMHSC_Partition", string4, string3, hSCCltEventQueue);
                            subscription.subscribe(4, "IBMHSC_Partition", string4, string3, hSCCltEventQueue);
                            subscription.subscribe(8, "IBMHSC_Partition", string4, string3, hSCCltEventQueue);
                            subscription.subscribe(16, "IBMHSC_Partition", string4, string3, hSCCltEventQueue);
                        }
                        catch (Throwable throwable) {
                            if (!_debug) break block15;
                            throwable.printStackTrace();
                        }
                    }
                    try {
                        subscription.subscribe(1, "IBMHSC_LparProfile", string4, string3, hSCCltEventQueue);
                        subscription.subscribe(2, "IBMHSC_LparProfile", string4, string3, hSCCltEventQueue);
                        subscription.subscribe(4, "IBMHSC_LparProfile", string4, string3, hSCCltEventQueue);
                    }
                    catch (Throwable throwable) {
                        if (!_debug) break block16;
                        throwable.printStackTrace();
                    }
                }
                try {
                    subscription.subscribe(1, "IBMHSC_SystemProfile", string4, string3, hSCCltEventQueue);
                    subscription.subscribe(2, "IBMHSC_SystemProfile", string4, string3, hSCCltEventQueue);
                    subscription.subscribe(4, "IBMHSC_SystemProfile", string4, string3, hSCCltEventQueue);
                }
                catch (Throwable throwable) {
                    if (!_debug) break block17;
                    throwable.printStackTrace();
                }
            }
            try {
                subscription.subscribe(1, "IBMHSC_Frame", string4, string3, hSCCltEventQueue);
                subscription.subscribe(2, "IBMHSC_Frame", string4, string3, hSCCltEventQueue);
                subscription.subscribe(4, "IBMHSC_Frame", string4, string3, hSCCltEventQueue);
                subscription.subscribe(-1, null, string4, string3, hSCCltEventQueue);
                subscription.subscribe(-2, null, string4, string3, hSCCltEventQueue);
            }
            catch (Throwable throwable) {
                if (!_debug) break block18;
                throwable.printStackTrace();
            }
        }
    }

    public static Object getCIMAttrValue(CIMInstance cIMInstance, String string) {
        CIMValue cIMValue;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            return cIMValue.getValue();
        }
        return null;
    }

    public static CIMValue getCIMAttribute(CIMInstance cIMInstance, String string) throws CIMException {
        return cIMInstance.getProperty(string).getValue();
    }

    public static String formatField(String string, String string2) {
        if (string == null || "".equals(string)) {
            string = "null";
        }
        if (string2 == null) {
            string2 = ",";
        }
        if (string.endsWith("=")) {
            string = string + "null";
        }
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"", true);
        StringBuffer stringBuffer = null;
        if (stringTokenizer.countTokens() > 1) {
            while (stringTokenizer.hasMoreTokens()) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer("\"");
                }
                bl = true;
                String string3 = stringTokenizer.nextToken();
                stringBuffer.append(string3);
                if (!stringTokenizer.hasMoreTokens() || string3.equals("\"")) continue;
                stringBuffer.append("\"");
            }
        }
        if (!bl && string.indexOf(string2) != -1) {
            bl = true;
        }
        if (!bl && string.indexOf("\n") != -1) {
            bl = true;
        }
        if (bl && stringBuffer != null) {
            stringBuffer.append("\"");
            string = stringBuffer.toString();
        } else if (bl) {
            stringBuffer = new StringBuffer("\"").append(string).append("\"");
            string = stringBuffer.toString();
        }
        return string;
    }

    public static HscCimomListener getEventHandler() {
        return _cimomListener;
    }

    static {
        s_utilOwner = 1;
        _strArrayType = new CIMDataType(29);
        subscription = null;
        _cimomListener = null;
        _debug = false;
    }
}

